/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.HttpProxySettings;
import oracle.install.ivw.common.bean.MyOracleSupportSettings;
import oracle.install.ivw.common.resource.AutoUpdatesErrorCode;
import oracle.install.ivw.common.resource.AutoUpdatesManagerException;
import oracle.install.ivw.common.util.OracleInstaller;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesHelper;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicAPISessionDetails;
import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicInstallAPISession;
import oracle.sysman.oii.oiii.OiiiApplyUpdates;
import oracle.sysman.oii.oiii.OiiiInstallUpdate;
import oracle.sysman.oii.oiii.OiiiParseMetadata;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiii.OiiiPlaceHolderAuthenticate;
import oracle.sysman.oii.oiim.OiimARUAuthException;
import oracle.sysman.oii.oiim.OiimARUConnection;
import oracle.sysman.oii.oiim.OiimARUOrionConnection;
import oracle.sysman.oii.oiim.OiimARUPatchData;
import oracle.sysman.oii.oiim.OiimDownloadProgressStatusHolder;
import oracle.sysman.oii.oiim.OiimMOSException;
import oracle.sysman.oii.oiim.OiimMOSState;
import oracle.sysman.oii.oiim.OiimUpdatesRestart;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixIniParsingException;
import org.xml.sax.SAXException;

public class OUIUpdateManager
extends UpdateManager {
    private ArrayList<OiiiPatchMetadata> allInstallUpdatesList;
    private ArrayList<OiiiPatchMetadata> allOneOffsList;
    private List<OiiiPatchMetadata> categorizedListOfPatches;
    private OiiiPatchMetadata ouiUpdate;
    private OiiiPatchMetadata opatchUpdate;
    private OiiiParseMetadata pm;
    private static final Logger logger = Logger.getLogger(OUIUpdateManager.class.getName());
    private ArrayList cpuUpdates;
    private boolean hasDownloadedMetadata = false;
    private String downloadedMetadata;
    private static boolean useOldConn = false;
    private UpdatesHelper updatesHelper = UpdatesHelper.getInstance();

    @Override
    public boolean getConnection(MyOracleSupportSettings details, HttpProxySettings p) throws AutoUpdatesManagerException {
        String metaLinkURL;
        if (useOldConn) {
            OiimARUConnection.resetAruConnection();
            metaLinkURL = "https://updates.oracle.com";
        } else {
            OiimARUOrionConnection.resetAruConnection();
            metaLinkURL = "https://updates.oracle.com";
        }
        OiiiPlaceHolderAuthenticate auth = OiiiPlaceHolderAuthenticate.getAuthObject(null);
        auth.setProxyHost(null);
        auth.setProxyPort(0);
        boolean connected = false;
        String userName = details.getUserId();
        String password = details.getPassword();
        Properties prp = new Properties();
        if (p != null) {
            prp = p.getProperties();
        }
        auth.setAuthenticateInfo(userName, password, metaLinkURL, prp);
        Object aruConn = null;
        try {
            aruConn = useOldConn ? OiimARUConnection.getAruConnection() : OiimARUOrionConnection.getAruOrionConnection();
        }
        catch (OiimARUAuthException e) {
            if (e.getErrorCode() == 2) {
                throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.NO_PROXY_PROVIDED, new Object[0]);
            }
            logger.log(Level.SEVERE, "Connection to My Oracle Support Failed.");
            this.printErrorCode(e.getErrorCode());
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_CONNECTION_FAILED, new Object[0]);
        }
        catch (Exception e) {
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_CONNECTION_FAILED, new Object[0]);
        }
        if (aruConn == null) {
            connected = false;
        } else {
            connected = true;
            logger.log(Level.INFO, "Connection to metalink was successful");
        }
        logger.log(Level.FINEST, "Returning " + connected + " from OUIUpdateManager");
        return connected;
    }

    private OiimARUConnection getConnectionObject(MyOracleSupportSettings details, HttpProxySettings p) throws AutoUpdatesManagerException {
        String metaLinkURL;
        Object aruConn = null;
        if (useOldConn) {
            OiimARUConnection.resetAruConnection();
            metaLinkURL = "https://updates.oracle.com";
        } else {
            OiimARUOrionConnection.resetAruConnection();
            metaLinkURL = "https://updates.oracle.com";
        }
        OiiiPlaceHolderAuthenticate auth = OiiiPlaceHolderAuthenticate.getAuthObject(null);
        boolean connected = false;
        String userName = details.getUserId();
        String password = details.getPassword();
        Properties prp = new Properties();
        if (p != null) {
            prp = p.getProperties();
        }
        auth.setAuthenticateInfo(userName, password, metaLinkURL, prp);
        try {
            aruConn = useOldConn ? OiimARUConnection.getAruConnection() : OiimARUOrionConnection.getAruOrionConnection();
        }
        catch (OiimARUAuthException e) {
            if (e.getErrorCode() == 2) {
                throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.NO_PROXY_PROVIDED, new Object[0]);
            }
            logger.log(Level.SEVERE, "Connection to My Oracle Support Failed.");
            this.printErrorCode(e.getErrorCode());
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_CONNECTION_FAILED, new Object[0]);
        }
        catch (Exception e) {
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.MYORACLESUPPORT_CONNECTION_FAILED, new Object[0]);
        }
        if (aruConn == null) {
            connected = false;
        } else {
            connected = true;
            logger.log(Level.INFO, "Connection to My Oracle Support was successful");
        }
        logger.log(Level.FINEST, "Returning " + connected + " from OUIUpdateManager");
        return aruConn;
    }

    private void printErrorCode(int err) {
        switch (err) {
            case 0: {
                logger.log(Level.SEVERE, "Error code: ACCESS_DENIED");
                break;
            }
            case 1: {
                logger.log(Level.SEVERE, "Error code: INVALID_URL");
                break;
            }
            case 3: {
                logger.log(Level.SEVERE, "Error code: UNKNOWN_HOST");
                break;
            }
            case 4: {
                logger.log(Level.SEVERE, "Error code: MALFORMED_URL");
                break;
            }
            case 5: {
                logger.log(Level.SEVERE, "Error code: DWNLD_PATCH_ERR");
                break;
            }
            case 6: {
                logger.log(Level.SEVERE, "Error code: NOT_ABLE_TO_CONNECT_TO_MOS");
                break;
            }
            case 7: {
                logger.log(Level.SEVERE, "Error code: CONNECTION_REFUSED");
                break;
            }
            case 8: {
                logger.log(Level.SEVERE, "Error code: URL_NOT_FOUND");
                break;
            }
            case 9: {
                logger.log(Level.SEVERE, "Error code: REQUEST_TIMEOUT");
                break;
            }
            case 11: {
                logger.log(Level.SEVERE, "Error code: SERVER_ERROR");
                break;
            }
            case 13: {
                logger.log(Level.SEVERE, "Error code: PROTOCOL_NOT_SUPPORTED");
                break;
            }
            case 14: {
                logger.log(Level.SEVERE, "Error code: UNKNOWN_ERROR");
                break;
            }
            case 15: {
                logger.log(Level.SEVERE, "Error code: HTTP_PARSE_ERROR");
                break;
            }
            case 16: {
                logger.log(Level.SEVERE, "Error code: LOGIN_FAILURE");
                break;
            }
            case 17: {
                logger.log(Level.SEVERE, "Error code: INVALID_RESOURCE");
                break;
            }
            case 18: {
                logger.log(Level.SEVERE, "Error code: EOF_ERROR");
                break;
            }
            case 19: {
                logger.log(Level.SEVERE, "Error code: FILE_NOT_FOUND");
                break;
            }
            case 20: {
                logger.log(Level.SEVERE, "Error code: PROTOCOL_ERROR");
            }
        }
    }

    public String getMetadata(MyOracleSupportSettings details, HttpProxySettings p, String destDir) throws Exception {
        String location = null;
        location = useOldConn ? "https://updates.oracle.com" : "https://updates.oracle.com";
        String paramFileLocation = System.getProperty("oracle.installer.startup_location") + File.separator + "oraparam.ini";
        List args = Application.getInstance().getArguments();
        if (args != null && args.size() > 0) {
            Iterator i = args.iterator();
            while (i.hasNext()) {
                String command = (String)i.next();
                if (!"-paramFile".equals(command)) continue;
                paramFileLocation = (String)i.next();
            }
        }
        String version = this.getOraparamValue(paramFileLocation, "Updates", "UPDATE_VERSION");
        int bug = 0;
        String bugId = this.getOraparamValue(paramFileLocation, "Updates", "UPDATE_BUGID");
        if (bugId != null) {
            try {
                bug = Integer.parseInt(bugId);
            }
            catch (Exception e) {
                throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.UPDATES_SECTION_MISSING, e);
            }
        } else {
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.UPDATES_SECTION_MISSING, new Object[0]);
        }
        boolean connected = this.getConnection(details, p);
        logger.log(Level.FINEST, "The connection to MOS returned " + connected);
        String dlo = null;
        dlo = useOldConn ? OiimARUConnection.getMetaDataXML((String)location, (int)bug, (String)version, (String)destDir) : OiimARUOrionConnection.getMetaDataXML((String)location, (int)bug, (String)version, (String)destDir);
        return dlo;
    }

    @Override
    public boolean parseMetadata(String metadataXML, int platform, String homeType) throws AutoUpdatesManagerException {
        this.clearAllPatches();
        logger.log(Level.FINEST, "Parsing metadata");
        this.pm = new OiiiParseMetadata(metadataXML);
        OiimDownloadProgressStatusHolder dp = new OiimDownloadProgressStatusHolder();
        boolean parsedProperly = false;
        try {
            this.pm.parseMetadata(platform);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "FileNotFoundException Exception");
            logger.log(Level.WARNING, "The metadata xml was not downloaded properly");
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.METADATA_PARSE_FAILED, new Object[0]);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException Exception");
            logger.log(Level.WARNING, "The metadata xml was not downloaded properly");
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.METADATA_PARSE_FAILED, new Object[0]);
        }
        catch (SAXException e) {
            logger.log(Level.WARNING, "SAXException Exception");
            logger.log(Level.WARNING, "The metadata xml was not downloaded properly");
            throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.METADATA_PARSE_FAILED, new Object[0]);
        }
        parsedProperly = true;
        boolean isExadata = MachineInfo.getInstance().isHostExadata();
        if (parsedProperly) {
            ArrayList<OiiiPatchMetadata> installUpdatesList;
            ArrayList<OiiiPatchMetadata> oneOffPatchesList;
            this.allOneOffsList = null;
            this.allInstallUpdatesList = null;
            this.ouiUpdate = this.calculateOUIUpdate(homeType, isExadata);
            this.opatchUpdate = this.calculateOPatchUpdate(homeType, isExadata);
            this.categorizedListOfPatches = new ArrayList<OiiiPatchMetadata>();
            if (this.ouiUpdate != null) {
                this.categorizedListOfPatches.add(this.ouiUpdate);
            }
            if (this.opatchUpdate != null) {
                this.categorizedListOfPatches.add(this.opatchUpdate);
            }
            if ((oneOffPatchesList = this.calculateListOfOneOffs(homeType, isExadata)) != null && oneOffPatchesList.size() > 0) {
                this.allOneOffsList = new ArrayList();
                this.allOneOffsList = oneOffPatchesList;
                this.categorizedListOfPatches.addAll(oneOffPatchesList);
            }
            if ((installUpdatesList = this.calculateListOfInstallUpdates(homeType, isExadata)) != null && installUpdatesList.size() > 0) {
                this.allInstallUpdatesList = new ArrayList();
                this.allInstallUpdatesList = installUpdatesList;
                this.categorizedListOfPatches.addAll(installUpdatesList);
            }
            if (this.cpuUpdates == null) {
                if (this.pm.getCPULocation() != null && this.pm.getCPULocation().length() > 0) {
                    this.cpuUpdates = this.getCPUUpdatesList();
                    if (this.cpuUpdates != null && this.cpuUpdates.size() > 0) {
                        this.categorizedListOfPatches.addAll(this.cpuUpdates);
                    }
                } else {
                    logger.log(Level.INFO, "CPU URL not mentioned in the metadata. Skipping CPU updates retrieval.");
                }
            }
        }
        return parsedProperly;
    }

    private ArrayList<OiiiPatchMetadata> calculateListOfOneOffs(String homeType, boolean isExadata) {
        ArrayList<OiiiPatchMetadata> consolidatedPatchesList = new ArrayList<OiiiPatchMetadata>();
        ArrayList<OiiiPatchMetadata> oneOffPatchesList = new ArrayList<OiiiPatchMetadata>();
        if (this.allOneOffsList == null || this.allOneOffsList.size() == 0) {
            if (this.getOneOffList("all") != null && this.getOneOffList("all").size() > 0) {
                consolidatedPatchesList.addAll(this.getOneOffList("all"));
            }
            if (this.getOneOffList(homeType) != null && this.getOneOffList(homeType).size() > 0) {
                consolidatedPatchesList.addAll(this.getOneOffList(homeType));
            }
            if (consolidatedPatchesList != null && consolidatedPatchesList.size() > 0) {
                oneOffPatchesList.clear();
                oneOffPatchesList = this.getFilteredPatches(isExadata, consolidatedPatchesList);
            }
        }
        return oneOffPatchesList;
    }

    public OiiiPatchMetadata calculateOUIUpdate(String homeType, boolean isExadata) {
        OiiiPatchMetadata ouiUpd;
        OiiiPatchMetadata calculatedOUIUpdate = null;
        if (this.ouiUpdate == null && (ouiUpd = this.getOUIUpdateForHome()) != null) {
            logger.log(Level.FINEST, " In calculateOUIUpdate method.. oui update " + ouiUpd.getPatchBugNumber());
            ArrayList<OiiiPatchMetadata> ouiPatchList = new ArrayList<OiiiPatchMetadata>();
            ouiPatchList.add(ouiUpd);
            ArrayList<OiiiPatchMetadata> updates = this.getFilteredPatches(isExadata, ouiPatchList);
            if (updates != null && updates.size() == 1) {
                calculatedOUIUpdate = (OiiiPatchMetadata)updates.get(0);
            }
        }
        return calculatedOUIUpdate;
    }

    public OiiiPatchMetadata calculateOPatchUpdate(String homeType, boolean isExadata) {
        OiiiPatchMetadata opatchUpd;
        OiiiPatchMetadata calculatedOPatchUpdate = null;
        if (this.opatchUpdate == null && (opatchUpd = this.getOPatchUpdateForHome()) != null) {
            logger.log(Level.FINEST, " In calculateOPatchUpdate method.. opatch update " + opatchUpd.getPatchBugNumber());
            ArrayList<OiiiPatchMetadata> opatchList = new ArrayList<OiiiPatchMetadata>();
            opatchList.add(opatchUpd);
            ArrayList<OiiiPatchMetadata> updates = this.getFilteredPatches(isExadata, opatchList);
            if (updates != null && updates.size() == 1) {
                calculatedOPatchUpdate = (OiiiPatchMetadata)updates.get(0);
            }
        }
        return calculatedOPatchUpdate;
    }

    public ArrayList<OiiiPatchMetadata> getFilteredPatches(boolean isExadata, ArrayList<OiiiPatchMetadata> consolidatedPatchesList) {
        ArrayList<OiiiPatchMetadata> patches = new ArrayList<OiiiPatchMetadata>();
        for (OiiiPatchMetadata m : consolidatedPatchesList) {
            logger.info("In getFilteredPatches method.. " + m.getPatchBugNumber());
            Properties props = m.getPropertyList();
            if (props == null || props.size() <= 0) continue;
            String exadataPatchProperty = props.getProperty("isExadataPatch");
            String nonExadataPatchProperty = props.getProperty("isExadataOnlyPatch");
            logger.log(Level.FINEST, "For patch: " + m.getPatchBugNumber() + " exadataProperty : " + exadataPatchProperty + " and isExadataOnlyPatch: " + nonExadataPatchProperty);
            if (isExadata) {
                if (exadataPatchProperty == null || exadataPatchProperty.length() <= 0 || !exadataPatchProperty.equalsIgnoreCase("true")) continue;
                patches.add(m);
                continue;
            }
            if (nonExadataPatchProperty == null || nonExadataPatchProperty.length() <= 0 || !nonExadataPatchProperty.equalsIgnoreCase("false")) continue;
            patches.add(m);
        }
        return patches;
    }

    private ArrayList<OiiiPatchMetadata> calculateListOfInstallUpdates(String homeType, boolean isExadata) {
        ArrayList<OiiiPatchMetadata> consolidatedPatchesList = new ArrayList<OiiiPatchMetadata>();
        ArrayList<OiiiPatchMetadata> installUpdatesList = new ArrayList<OiiiPatchMetadata>();
        if (this.allInstallUpdatesList == null || this.allInstallUpdatesList.size() == 0) {
            if (this.getInstallUpdatesList("all") != null && this.getInstallUpdatesList("all").size() > 0) {
                consolidatedPatchesList.addAll(this.getInstallUpdatesList("all"));
            }
            if (this.getInstallUpdatesList(homeType) != null && this.getInstallUpdatesList(homeType).size() > 0) {
                consolidatedPatchesList.addAll(this.getInstallUpdatesList(homeType));
            }
            if (consolidatedPatchesList != null && consolidatedPatchesList.size() > 0) {
                installUpdatesList.clear();
                installUpdatesList = this.getFilteredPatches(isExadata, consolidatedPatchesList);
            }
        }
        return installUpdatesList;
    }

    private void clearAllPatches() {
        this.allInstallUpdatesList = null;
        this.allOneOffsList = null;
        this.categorizedListOfPatches = null;
        this.ouiUpdate = null;
        this.opatchUpdate = null;
        this.cpuUpdates = null;
    }

    @Override
    public List<String> getListOfBugNumbers(List patches) {
        ArrayList<String> bugNumbers = new ArrayList<String>();
        if (patches != null && patches.size() > 0) {
            for (Object m : patches) {
                if (!(m instanceof OiiiPatchMetadata)) continue;
                bugNumbers.add("" + ((OiiiPatchMetadata)m).getPatchBugNumber());
            }
        }
        return bugNumbers;
    }

    @Override
    public String getDownloadedMetadata() {
        return this.downloadedMetadata;
    }

    @Override
    public boolean hasDownloadHappened() {
        return this.hasDownloadedMetadata;
    }

    @Override
    public boolean downloadAndParseMetadata(MyOracleSupportSettings details, HttpProxySettings p, String destDir) throws AutoUpdatesManagerException {
        boolean succeeded;
        block10: {
            succeeded = false;
            Application application = Application.getInstance();
            this.hasDownloadedMetadata = false;
            try {
                int plat;
                OracleInstaller installer;
                String customMetadata;
                String metadata = this.getMetadata(details, p, destDir);
                metadata = customMetadata = System.getProperty("CUSTOM_METADATA", metadata);
                int platform = oracle.install.commons.base.util.PlatformInfo.getInstance().getARUId();
                this.downloadedMetadata = metadata;
                if (application instanceof OracleInstaller && (installer = (OracleInstaller)Application.getInstance()).getInstallerMode() != null && installer.getInstallerMode() == OracleInstaller.InstallerMode.STANDALONE_DOWNLOAD_MODE && (plat = this.getPlatformFromCmdLine()) != 0) {
                    platform = plat;
                }
                if (metadata != null) {
                    OiiiInstallUpdate.removeARUXMLsAfterDownload((boolean)false);
                    String homeType = application.getString("product.name", null, new Object[0]);
                    try {
                        succeeded = this.parseMetadata(metadata, platform, homeType);
                    }
                    catch (AutoUpdatesManagerException e) {
                        succeeded = false;
                        logger.log(Level.SEVERE, "The metadata xml was not parsed properly", (Throwable)((Object)e));
                        throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.METADATA_PARSE_FAILED, new Object[0]);
                    }
                    if (!succeeded) {
                        throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.METADATA_PARSE_FAILED, new Object[0]);
                    }
                    break block10;
                }
                throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.FAILURE_IN_UPDATES_RETRIEVAL, new Object[0]);
            }
            catch (AutoUpdatesManagerException e) {
                succeeded = false;
                if (e.getErrorInfo().getErrorCode() == AutoUpdatesErrorCode.UPDATES_SECTION_MISSING) {
                    logger.log(Level.SEVERE, "The oraparam file is not having the updates information", (Throwable)((Object)e));
                    throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.UPDATES_SECTION_MISSING, new Object[]{e});
                }
                throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.FAILURE_IN_UPDATES_RETRIEVAL, new Object[]{e});
            }
            catch (Exception e) {
                succeeded = false;
                logger.log(Level.SEVERE, "The metadata xml was not downloaded properly", e);
                throw new AutoUpdatesManagerException((ErrorCode)AutoUpdatesErrorCode.FAILURE_IN_UPDATES_RETRIEVAL, new Object[0]);
            }
        }
        if (succeeded) {
            this.hasDownloadedMetadata = true;
            logger.log(Level.FINEST, "Metadata downloaded successfully");
        }
        return succeeded;
    }

    private int getPlatformFromCmdLine() {
        int plat = 0;
        List argList = Application.getInstance().getArguments();
        if (argList != null && argList.size() > 0) {
            for (String a : argList) {
                String[] arr;
                if (a == null || !a.startsWith("oracle.install.platformID") || (arr = a.split("=")) == null || arr.length <= 0) continue;
                try {
                    plat = Integer.parseInt(arr[1]);
                }
                catch (NumberFormatException e) {
                    logger.log(Level.SEVERE, "Exception occurred while reading platform id" + e);
                }
                break;
            }
        }
        return plat;
    }

    public String getOraparamValue(String paramFileLocation, String sectionName, String key) {
        logger.log(Level.FINEST, "UpdateManager: Loading " + paramFileLocation);
        OiixIniFile oIniFile = new OiixIniFile(paramFileLocation);
        String value = null;
        try {
            oIniFile.readFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OiixIniParsingException e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "UpdateManager: retrieving value for key: " + key);
        value = oIniFile.getValue(sectionName, key);
        logger.log(Level.INFO, "UpdateManager: retrieving value for key: " + key + " value: " + value);
        return value;
    }

    @Override
    public ArrayList<OiiiPatchMetadata> getInstallUpdates() {
        return this.allInstallUpdatesList;
    }

    @Override
    public ArrayList<OiiiPatchMetadata> getOneOffList() {
        return this.allOneOffsList;
    }

    @Override
    public ArrayList<OiiiPatchMetadata> getOneOffList(String homeType) {
        if (this.pm != null) {
            return this.pm.getApplicableOneoffList(homeType);
        }
        return this.getOneOffList();
    }

    public ArrayList<OiiiPatchMetadata> getInstallUpdatesList(String home) {
        if (this.pm != null) {
            return this.pm.getInstallUpdates(home);
        }
        return this.getInstallUpdates();
    }

    @Override
    public OiiiPatchMetadata getOUIUpdate() {
        return this.ouiUpdate;
    }

    public OiiiPatchMetadata getOUIUpdateForHome() {
        OiiiPatchMetadata update = this.pm.getOUIUpdate();
        return update;
    }

    public OiiiPatchMetadata getOPatchUpdateForHome() {
        OiiiPatchMetadata update = this.pm.getOPatchUpdate();
        return update;
    }

    @Override
    public OiiiPatchMetadata getOPatchUpdate() {
        return this.opatchUpdate;
    }

    @Override
    public boolean getRestartInstall() {
        boolean requiresRestart = false;
        if (this.pm != null) {
            requiresRestart = this.pm.getRestartInstall();
        }
        return requiresRestart;
    }

    @Override
    public List getListOfUpdatesSelected() {
        return this.categorizedListOfPatches;
    }

    @Override
    public long getTotalDownloadSizeForAllPatches(MyOracleSupportSettings details, HttpProxySettings proxyDet) {
        List allUpdates = this.getListOfUpdatesSelected();
        int size = allUpdates.size();
        long totalBytes = 0L;
        ArrayList<String> patchUrls = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)allUpdates.get(i);
            try {
                if (this.getConnection(details, proxyDet)) {
                    OiimARUConnection aruConn = this.getConnectionObject(details, proxyDet);
                    ArrayList patchDataList = null;
                    patchDataList = useOldConn ? OiimARUConnection.download((OiimARUConnection)aruConn, (OiiiPatchMetadata)bid) : OiimARUOrionConnection.download((OiimARUConnection)aruConn, (OiiiPatchMetadata)bid);
                    int size_patchData = patchDataList == null ? 0 : patchDataList.size();
                    for (int j = 0; j < size_patchData; ++j) {
                        OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                        patchUrls.add(pd.getPatchUrl());
                        totalBytes += pd.getSize();
                    }
                }
                logger.log(Level.INFO, "The total download size of all the patches is :" + totalBytes);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not get connection to MOS, hence not able to get total download size", e);
            }
        }
        return totalBytes;
    }

    @Override
    public ArrayList getAllCPU() {
        return this.cpuUpdates;
    }

    @Override
    public ArrayList getCPUUpdatesList() {
        if (this.cpuUpdates == null) {
            this.cpuUpdates = new ArrayList();
            ArrayList componentList = new ArrayList();
            String sourceLoc = new File(new File(System.getProperty("oracle.installer.startup_location")).getParent(), "stage").getAbsolutePath();
            try {
                String topLevelComponent = Application.getInstance().getString("AutoUpdates.hometypeTag.name", null, new Object[0]);
                if (topLevelComponent != null) {
                    if (topLevelComponent.equalsIgnoreCase("db")) {
                        componentList = OiiiInstallUpdate.getCompsToInstall((String)"oracle.server", (String)"EE", (String)sourceLoc);
                        logger.log(Level.INFO, "No of components in db install : " + componentList.size());
                    } else if (topLevelComponent.equalsIgnoreCase("crs")) {
                        componentList = OiiiInstallUpdate.getCompsToInstall((String)"oracle.crs", (String)"Complete", (String)sourceLoc);
                        logger.log(Level.INFO, "No of components in crs install : " + componentList.size());
                    } else if (topLevelComponent.equalsIgnoreCase("client")) {
                        componentList = OiiiInstallUpdate.getCompsToInstall((String)"oracle.client", (String)"Administrator", (String)sourceLoc);
                        ArrayList clientCompList = new ArrayList(componentList);
                        ArrayList customCompList = OiiiInstallUpdate.getCompsToInstall((String)"oracle.client", (String)"Custom", (String)sourceLoc);
                        clientCompList.addAll(customCompList);
                        componentList = clientCompList;
                        logger.log(Level.INFO, "No of components in client install : " + componentList.size());
                    } else if (topLevelComponent.equalsIgnoreCase("demos")) {
                        componentList = OiiiInstallUpdate.getCompsToInstall((String)"oracle.companionCD.db", (String)"DB", (String)sourceLoc);
                        logger.log(Level.INFO, "No of components in demos install : " + componentList.size());
                    }
                    if (componentList != null && componentList.size() > 0) {
                        logger.log(Level.INFO, "Checking for CPU updates..");
                        int platform = oracle.install.commons.base.util.PlatformInfo.getInstance().getARUId();
                        List cpuPatches = OiiiInstallUpdate.getApplicableCPUList((List)componentList, (int)platform);
                        if (cpuPatches != null && cpuPatches.size() > 0) {
                            for (Object d : cpuPatches) {
                                if (!(d instanceof OiiiPatchMetadata)) continue;
                                ((OiiiPatchMetadata)d).setType("cpus");
                                ((OiiiPatchMetadata)d).setDesc(OiiiInstallUpdate.getDisplayName());
                                this.cpuUpdates.add(d);
                            }
                        }
                        logger.log(Level.INFO, "No of CPU updates found: " + this.cpuUpdates.size());
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while retrieving the list of CPU updates");
            }
        }
        return this.cpuUpdates;
    }

    @Override
    public boolean doRestart(String[] args, String downloadLoc, String paramFile, int ouiBugID, int OPatchBugID) {
        RuntimeMXBean RuntimemxBean;
        List<String> jvmArgs;
        ArrayList<String> jvmArgsFromCmdLine = new ArrayList<String>();
        String prereqLoc = this.updatesHelper.getPrereqUpdateDir(downloadLoc);
        String cmdLinePrereq = System.getProperty("oracle.install.cvu.prereq_xml_loc");
        if ((cmdLinePrereq == null || cmdLinePrereq.length() == 0) && prereqLoc != null && prereqLoc.length() > 0 && new File(prereqLoc).exists()) {
            jvmArgsFromCmdLine.add("-Doracle.install.cvu.prereq_xml_loc=" + prereqLoc);
        }
        if ((jvmArgs = (RuntimemxBean = ManagementFactory.getRuntimeMXBean()).getInputArguments()) != null && jvmArgs.size() > 0) {
            for (String s : jvmArgs) {
                String[] var;
                if (s == null || !s.startsWith("-D") && !s.startsWith("-X")) continue;
                if (PlatformInfo.getInstance().isAix() && s.startsWith("-Djava.runtime.version") && (var = s.split("=")) != null && var.length > 1) {
                    String str = var[1];
                    Pattern pattern = Pattern.compile("\\s");
                    Matcher matcher = pattern.matcher(str);
                    if (matcher.find()) continue;
                }
                jvmArgsFromCmdLine.add(s);
                logger.log(Level.INFO, "JVM ARG:" + s);
            }
        }
        OiimUpdatesRestart oiRestartInstall = new OiimUpdatesRestart();
        boolean val = oiRestartInstall.restartOUI(args, downloadLoc, paramFile, ouiBugID, OPatchBugID, new ArrayList(jvmArgsFromCmdLine));
        logger.log(Level.INFO, "Returned " + val + " from the OUI restart api");
        Application.getInstance().restart(new Object[0]);
        return val;
    }

    @Override
    public void setCPUUpdatesList(ArrayList cpuUpdates) {
        this.cpuUpdates = cpuUpdates;
    }

    @Override
    public boolean applyOPatch(HashMap sessionHashMap, String downloadLoc, int opatchBugID) {
        String homeLoc = (String)sessionHashMap.get("ORACLE_HOME");
        logger.log(Level.FINEST, "Applying opatch on home " + homeLoc);
        boolean val = OiiiApplyUpdates.updateOPatch((String)homeLoc, (String)downloadLoc, (int)opatchBugID);
        if (!val) {
            logger.log(Level.SEVERE, "OPatch update application failed");
        }
        logger.log(Level.INFO, "Returned " + val + " from apply opatch API");
        return val;
    }

    @Override
    public List<String> getAllCPURequiredXmls() {
        return OiiiInstallUpdate.getAllCPURequiredXmls();
    }

    public boolean applyOneOffs(HashMap sessionHashMap, String downloadLoc, ArrayList oneOffPatchList) {
        boolean applied = false;
        String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
        OiicAPIInstaller mInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        mInstaller.disposeInstance();
        Properties prop = new Properties();
        if (downloadLoc == null || downloadLoc.length() == 0) {
            downloadLoc = System.getProperty("oracle.installer.scratchPath");
        }
        if (sessionHashMap != null) {
            OiicInstallAPISession installSession;
            String oracleHome = (String)sessionHashMap.get("ORACLE_HOME");
            prop.put("oracle.installer.scratchPath", scratchPathLoc);
            prop.put("oracle.installer.oui_loc", new File(oracleHome, "oui").getAbsolutePath());
            prop.put("oracle.installer.startup_location", new File(oracleHome, "oui").getAbsolutePath());
            try {
                mInstaller = OiicAPIInstaller.getAPIInstallerInstance();
                mInstaller.initInstallEnvironment(prop, true, 1);
                ArrayList<OiicAPISessionDetails> sessionList = new ArrayList<OiicAPISessionDetails>();
                HashMap sessionVar = new HashMap();
                sessionVar.putAll(sessionHashMap);
                sessionList.add(new OiicAPISessionDetails(null, null, sessionVar, null));
                mInstaller.registerInstallAPISession(sessionList);
                OiicIOUIAPISession session = mInstaller.initOUIAPISession();
                installSession = (OiicInstallAPISession)session;
                logger.log(Level.FINEST, "Session created before applying oneoffs: " + installSession);
                logger.log(Level.FINEST, " REMOTE_NODES value: ");
                String[] nodes = (String[])sessionHashMap.get("REMOTE_NODES");
                if (nodes != null) {
                    for (String n : nodes) {
                        logger.log(Level.FINEST, "Remote node: " + n);
                    }
                }
                installSession.releaseReaderLock();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error occurred while creating a installer session for applying one-offs :" + e.getCause());
                return applied;
            }
            OiiiApplyUpdates updatesCall = new OiiiApplyUpdates((OiicISession)installSession);
            ArrayList<String> args = new ArrayList<String>();
            if (!oracle.install.commons.base.util.PlatformInfo.getInstance().isWindows()) {
                String invLoc = "-invPtrLoc " + oracleHome + File.separator + "oraInst.loc";
                args.add(invLoc);
            }
            if (this.opatchUpdate != null && this.opatchUpdate.getPatchBugNumber() > 0) {
                try {
                    String ocmResponseFile = oracleHome + File.separator + "OPatch" + File.separator + "ocm.rsp";
                    BufferedWriter out = new BufferedWriter(new FileWriter(ocmResponseFile));
                    String ocmRspArg = "-ocmrf " + new File(ocmResponseFile).getAbsolutePath();
                    args.add(ocmRspArg);
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "Unable to create ocm.rsp file", e);
                }
            }
            applied = updatesCall.applyOneOffs(downloadLoc, downloadLoc, oracleHome, oneOffPatchList, args.toArray(new String[0]));
            installSession.dispose();
        }
        return applied;
    }

    @Override
    public boolean hasDownloadPrivileges(MyOracleSupportSettings mosSettings, HttpProxySettings proxyDetails) {
        boolean dwldPrivileges = false;
        String userName = mosSettings.getUserId();
        String password = mosSettings.getPassword();
        try {
            OiimARUConnection aruConn = this.getConnectionObject(mosSettings, proxyDetails);
            if (aruConn != null && aruConn instanceof OiimARUOrionConnection) {
                OiimMOSState mosState = ((OiimARUOrionConnection)aruConn).createMOSState(userName, password);
                OiimARUOrionConnection cfr_ignored_0 = (OiimARUOrionConnection)aruConn;
                boolean pdPrivileges = OiimARUOrionConnection.hasPatchDownloadPrivilege((OiimMOSState)mosState);
                logger.log(Level.FINEST, "Credentials provided has download privileges:" + pdPrivileges);
                if (pdPrivileges) {
                    dwldPrivileges = true;
                }
            }
        }
        catch (AutoUpdatesManagerException e) {
            logger.log(Level.FINEST, "Exception while connecting to My Oracle Support using OiimARUOrionConnection", (Throwable)((Object)e));
            return false;
        }
        catch (OiimMOSException e) {
            logger.log(Level.FINEST, "Exception occurred while trying to check for download privileges" + (Object)((Object)e));
            return false;
        }
        logger.log(Level.FINEST, "Credentials provided has download privileges:" + dwldPrivileges);
        return dwldPrivileges;
    }

    static {
        String useOldConnProperty = System.getProperty("USE_ARU_CONNECTION");
        if (useOldConnProperty != null && useOldConnProperty.equalsIgnoreCase("true")) {
            useOldConn = true;
        }
    }
}

